<?php

if (!function_exists('carer_sidebar_padding')) {
	/**
	 * Generate CSS codes for Sidebar Padding
	 */
	function carer_sidebar_padding() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-padding';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $carer_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-right'] != "" ) {
			$declaration['padding-right'] = $carer_redux_theme_opt[$var_name]['padding-right'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $carer_redux_theme_opt[$var_name]['padding-bottom'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-left'] != "" ) {
			$declaration['padding-left'] = $carer_redux_theme_opt[$var_name]['padding-left'];
		}
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_padding');
}


if (!function_exists('carer_sidebar_bg_color')) {
	/**
	 * Generate CSS codes for Sidebar Background Color
	 */
	function carer_sidebar_bg_color() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-bg-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['background-color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_bg_color');
}


if (!function_exists('carer_sidebar_text_align')) {
	/**
	 * Generate CSS codes for Sidebar Text Alignment
	 */
	function carer_sidebar_text_align() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-text-align';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['text-align'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_text_align');
}





if (!function_exists('carer_sidebar_title_padding')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Padding
	 */
	function carer_sidebar_title_padding() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-padding';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $carer_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-right'] != "" ) {
			$declaration['padding-right'] = $carer_redux_theme_opt[$var_name]['padding-right'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $carer_redux_theme_opt[$var_name]['padding-bottom'];
		}
		if( $carer_redux_theme_opt[$var_name]['padding-left'] != "" ) {
			$declaration['padding-left'] = $carer_redux_theme_opt[$var_name]['padding-left'];
		}
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_title_padding');
}


if (!function_exists('carer_sidebar_title_bg_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Background Color
	 */
	function carer_sidebar_title_bg_color() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-bg-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['background-color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_title_bg_color');
}


if (!function_exists('carer_sidebar_title_text_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Text Color
	 */
	function carer_sidebar_title_text_color() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-text-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_title_text_color');
}


if (!function_exists('carer_sidebar_title_font_size')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Font Size
	 */
	function carer_sidebar_title_font_size() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-font-size';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['font-size'] = $carer_redux_theme_opt[$var_name] . 'px';
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_title_font_size');
}


if (!function_exists('carer_sidebar_title_line_bottom_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Line Bottom Color
	 */
	function carer_sidebar_title_line_bottom_color() {
		global $carer_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-line-bottom-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title.widget-title-line-bottom:after'
		);

		if( !carer_get_redux_option( 'sidebar-settings-sidebar-title-show-line-bottom' ) ) {
			return;
		}

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['background-color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_sidebar_title_line_bottom_color');
}