<?php


if (!function_exists('carer_preloader_bg_color')) {
	/**
	 * Generate CSS codes for BG Color of Preloader
	 */
	function carer_preloader_bg_color() {
		global $carer_redux_theme_opt;
		$var_name = 'general-settings-page-preloader-bg-color';
		$declaration = array();
		$selector = array(
			'#preloader.three-layer-loaderbg .layer .overlay',
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['background-color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_preloader_bg_color');
}

if (!function_exists('carer_preloading_text_color')) {
	/**
	 * Generate CSS codes for text Color of Preloading text
	 */
	function carer_preloading_text_color() {
		global $carer_redux_theme_opt;
		$var_name = 'general-settings-page-preloading-text-color';
		$declaration = array();
		$selector = array(
			'#preloader .txt-loading .letters-loading',
			'#preloader .txt-loading .letters-loading:before',
		);

		//if empty then return
		if( !array_key_exists( $var_name, $carer_redux_theme_opt ) ) {
			return;
		}

		if( $carer_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$declaration['color'] = $carer_redux_theme_opt[$var_name];
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_preloading_text_color');
}

if (!function_exists('carer_preloading_text_typography')) {
	/**
	 * Generate CSS codes for Title Typography
	 */
	function carer_preloading_text_typography() {
		$var_name = 'general-settings-page-preloading-text-typography';
		$declaration = array();
		$selector = array(
			'#preloader .txt-loading .letters-loading',
			'#preloader .txt-loading .letters-loading:before',
		);
		$declaration = carer_redux_option_field_typography( $var_name );
		carer_dynamic_css_generator($selector, $declaration);
	}
	add_action('carer_dynamic_css_generator_action', 'carer_preloading_text_typography');
}