<?php

add_action( 'wp_enqueue_scripts', 'carer_mascot_child_theme_enqueue_styles' );
function carer_mascot_child_theme_enqueue_styles() {
    $parent_style = 'parent-style';
    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );

    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );

}

add_filter('woocommerce_product_single_add_to_cart_text', function() {
    return 'Book Now';
});
// add_filter('woocommerce_product_single_add_to_cart_text', function() {
//     return 'Book Now';
// });



// 1. Change "Add to Cart" button text to "Book Now" (single product page)
add_filter('woocommerce_product_single_add_to_cart_text', function($text) {
    return 'Book Now';
}, 10);

// 2. Redirect to cart page immediately after add to cart
add_filter('woocommerce_add_to_cart_redirect', function() {
    return wc_get_cart_url();
});

// 3. Rename "Continue Shopping" button to "Continue Payment"
add_filter('gettext', function($translated_text, $text, $domain) {
    if ($domain === 'woocommerce') {
        if ($text === 'Continue shopping') {
            $translated_text = 'Continue Payment';
        }
    }
    return $translated_text;
}, 10, 3);
add_filter('woocommerce_continue_shopping_redirect', function() {
    // Get the cart URL
    $cart_url = wc_get_cart_url();
    
    // Redirect to the cart page with a custom message
    return $cart_url;
});
add_filter('woocommerce_quantity_label', function() {
    return 'Days';
});
add_action( 'woocommerce_before_add_to_cart_quantity', 'bbloomer_echo_qty_front_add_cart' );
 
function bbloomer_echo_qty_front_add_cart() {
   global $product;
   if ( $product->get_min_purchase_quantity() == $product->get_max_purchase_quantity() ) return;
   echo '<div class="qty"><strong>Days:</strong> </div>'; 
}

add_filter('woocommerce_quantity_input_args', function($args, $product) {
    if ($product->get_id() == 17904) {
        $args['input_value'] = 2; // default value
        $args['min_value']   = 2; // minimum
        $args['max_value']   = 30; // maximum
        $args['product_name'] = 'Days'; // Label override
    }
    return $args;
}, 10, 2);

// 1. ADD FIELDS

add_action( 'woocommerce_register_form_start', 'ts_add_name_woo_account_registration' );

function ts_add_name_woo_account_registration() {
?>
<div class="row">
<p class="form-row form-row-first col-md-6">
<label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?> <span class="required">*</span></label>
<input required type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
</p>

<p class="form-row form-row-last col-md-6">
<label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?> <span class="required">*</span></label>
<input required type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
</p>
</div>
<div class="clear"></div>

<?php
}

// 2. VALIDATE FIELDS

add_filter( 'woocommerce_registration_errors', 'ts_validate_name_fields', 10, 3 );

function ts_validate_name_fields( $errors, $username, $email ) {
if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
$errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
}
if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
$errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!.', 'woocommerce' ) );
}
return $errors;
}

// 3. SAVE FIELDS

add_action( 'woocommerce_created_customer', 'ts_save_name_fields' );

function ts_save_name_fields( $customer_id ) {
if ( isset( $_POST['billing_first_name'] ) ) {
update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
update_user_meta( $customer_id, 'first_name', sanitize_text_field($_POST['billing_first_name']) );
}
if ( isset( $_POST['billing_last_name'] ) ) {
update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
update_user_meta( $customer_id, 'last_name', sanitize_text_field($_POST['billing_last_name']) );
}

}

add_action( 'wp_footer', function() {
    if ( is_checkout() ) : ?>
        <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            function updateCheckoutTexts() {
                // Change the checkbox label
                document.querySelectorAll('.wc-block-components-checkbox__label').forEach(function(el) {
                    if (el.textContent.trim() === "Add a note to your order") {
                        el.textContent = "Add a note to Book Service";
                    }
                });

                // Change the textarea placeholder
                document.querySelectorAll('.wc-block-components-textarea').forEach(function(el) {
                    if (el.getAttribute("placeholder") === "Notes about your order.") {
                        el.setAttribute("placeholder", "Write your service note here...");
                    }
                });
            }

            // Run once on load
            updateCheckoutTexts();

            // Watch for React re-renders
            const observer = new MutationObserver(updateCheckoutTexts);
            observer.observe(document.body, { childList: true, subtree: true });
        });
        </script>
    <?php endif;
    if ( is_cart() ) : ?>
        <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            function updateCartHeader() {
                document.querySelectorAll('.wc-block-cart-items__header-image span').forEach(function(el) {
                    if (el.textContent.trim() === "Product") {
                        el.textContent = "Service";
                    }
                });
            }

            // Run once on load
            updateCartHeader();

            // Watch for React re-renders
            const observer = new MutationObserver(updateCartHeader);
            observer.observe(document.body, { childList: true, subtree: true });
        });
        </script>
    <?php endif;
     if ( is_checkout() ) : ?>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const passwordWrappers = document.querySelectorAll('.wc-block-components-address-form__password');

            passwordWrappers.forEach(wrapper => {
                const input = wrapper.querySelector('input[type="password"], input[type="text"]');
                if (input && !wrapper.querySelector('.toggle-password')) {
                    // Create toggle button
                    const btn = document.createElement('button');
                    btn.type = 'button';
                    btn.className = 'toggle-password';
                    btn.innerHTML = '<i class="fas fa-eye"></i>'; // You can replace with fontawesome or dashicon

                    // Style button
                    btn.style.marginLeft = "6px";
                    btn.style.background = "transparent";
                    btn.style.border = "none";
                    btn.style.cursor = "pointer";
                    btn.style.fontSize = "16px";

                    // Toggle logic
                    btn.addEventListener('click', function() {
                        if (input.type === 'password') {
                            input.type = 'text';
                            btn.innerHTML = '<i class="fas fa-eye-slash"></i>'; // change icon
                        } else {
                            input.type = 'password';
                            btn.innerHTML = '<i class="fas fa-eye"></i>';
                        }
                    });

                    // Insert after input
                    input.parentNode.appendChild(btn);
                }
            });
        });
        </script>
    <?php endif;
});
add_action( 'woocommerce_payment_complete', 'my_after_payment_success' );

function my_after_payment_success( $order_id ) {
    $order = wc_get_order( $order_id );

    // Loop through ordered products
    foreach ( $order->get_items() as $item_id => $item ) {
        $product_id   = $item->get_product_id();
        $product_name = $item->get_name();
        $qty          = $item->get_quantity();

        // Example: log or trigger custom action
        error_log( "Payment successful for Service Order #$order_id → Product: $product_name (ID: $product_id) × $qty" );
    }

    // Example: send email, call API, give access, etc.
    // my_custom_function($order);
}
add_action('woocommerce_thankyou', 'auto_complete_paid_order', 10, 1);

function auto_complete_paid_order($order_id) {

    if (!$order_id) return;
 
    $order = wc_get_order($order_id);
 
    // Only run if the order has been paid

    if ($order && $order->is_paid() && $order->get_status() === 'processing') {

        $order->update_status('completed');

    }

}

 