
# Currency

Indicates the associated currency for an amount of money. Values correspond
to [ISO 4217](https://wikipedia.org/wiki/ISO_4217).

## Enumeration

`Currency`

## Fields

| Name | Description |
|  --- | --- |
| `UNKNOWN_CURRENCY` | Unknown currency |
| `AED` | United Arab Emirates dirham |
| `AFN` | Afghan afghani |
| `ALL` | Albanian lek |
| `AMD` | Armenian dram |
| `ANG` | Netherlands Antillean guilder |
| `AOA` | Angolan kwanza |
| `ARS` | Argentine peso |
| `AUD` | Australian dollar |
| `AWG` | Aruban florin |
| `AZN` | Azerbaijani manat |
| `BAM` | Bosnia and Herzegovina convertible mark |
| `BBD` | Barbados dollar |
| `BDT` | Bangladeshi taka |
| `BGN` | Bulgarian lev |
| `BHD` | Bahraini dinar |
| `BIF` | Burundian franc |
| `BMD` | Bermudian dollar |
| `BND` | Brunei dollar |
| `BOB` | Boliviano |
| `BOV` | Bolivian Mvdol |
| `BRL` | Brazilian real |
| `BSD` | Bahamian dollar |
| `BTN` | Bhutanese ngultrum |
| `BWP` | Botswana pula |
| `BYR` | Belarusian ruble |
| `BZD` | Belize dollar |
| `CAD` | Canadian dollar |
| `CDF` | Congolese franc |
| `CHE` | WIR Euro |
| `CHF` | Swiss franc |
| `CHW` | WIR Franc |
| `CLF` | Unidad de Fomento |
| `CLP` | Chilean peso |
| `CNY` | Chinese yuan |
| `COP` | Colombian peso |
| `COU` | Unidad de Valor Real |
| `CRC` | Costa Rican colon |
| `CUC` | Cuban convertible peso |
| `CUP` | Cuban peso |
| `CVE` | Cape Verdean escudo |
| `CZK` | Czech koruna |
| `DJF` | Djiboutian franc |
| `DKK` | Danish krone |
| `DOP` | Dominican peso |
| `DZD` | Algerian dinar |
| `EGP` | Egyptian pound |
| `ERN` | Eritrean nakfa |
| `ETB` | Ethiopian birr |
| `EUR` | Euro |
| `FJD` | Fiji dollar |
| `FKP` | Falkland Islands pound |
| `GBP` | Pound sterling |
| `GEL` | Georgian lari |
| `GHS` | Ghanaian cedi |
| `GIP` | Gibraltar pound |
| `GMD` | Gambian dalasi |
| `GNF` | Guinean franc |
| `GTQ` | Guatemalan quetzal |
| `GYD` | Guyanese dollar |
| `HKD` | Hong Kong dollar |
| `HNL` | Honduran lempira |
| `HRK` | Croatian kuna |
| `HTG` | Haitian gourde |
| `HUF` | Hungarian forint |
| `IDR` | Indonesian rupiah |
| `ILS` | Israeli new shekel |
| `INR` | Indian rupee |
| `IQD` | Iraqi dinar |
| `IRR` | Iranian rial |
| `ISK` | Icelandic króna |
| `JMD` | Jamaican dollar |
| `JOD` | Jordanian dinar |
| `JPY` | Japanese yen |
| `KES` | Kenyan shilling |
| `KGS` | Kyrgyzstani som |
| `KHR` | Cambodian riel |
| `KMF` | Comoro franc |
| `KPW` | North Korean won |
| `KRW` | South Korean won |
| `KWD` | Kuwaiti dinar |
| `KYD` | Cayman Islands dollar |
| `KZT` | Kazakhstani tenge |
| `LAK` | Lao kip |
| `LBP` | Lebanese pound |
| `LKR` | Sri Lankan rupee |
| `LRD` | Liberian dollar |
| `LSL` | Lesotho loti |
| `LTL` | Lithuanian litas |
| `LVL` | Latvian lats |
| `LYD` | Libyan dinar |
| `MAD` | Moroccan dirham |
| `MDL` | Moldovan leu |
| `MGA` | Malagasy ariary |
| `MKD` | Macedonian denar |
| `MMK` | Myanmar kyat |
| `MNT` | Mongolian tögrög |
| `MOP` | Macanese pataca |
| `MRO` | Mauritanian ouguiya |
| `MUR` | Mauritian rupee |
| `MVR` | Maldivian rufiyaa |
| `MWK` | Malawian kwacha |
| `MXN` | Mexican peso |
| `MXV` | Mexican Unidad de Inversion |
| `MYR` | Malaysian ringgit |
| `MZN` | Mozambican metical |
| `NAD` | Namibian dollar |
| `NGN` | Nigerian naira |
| `NIO` | Nicaraguan córdoba |
| `NOK` | Norwegian krone |
| `NPR` | Nepalese rupee |
| `NZD` | New Zealand dollar |
| `OMR` | Omani rial |
| `PAB` | Panamanian balboa |
| `PEN` | Peruvian sol |
| `PGK` | Papua New Guinean kina |
| `PHP` | Philippine peso |
| `PKR` | Pakistani rupee |
| `PLN` | Polish złoty |
| `PYG` | Paraguayan guaraní |
| `QAR` | Qatari riyal |
| `RON` | Romanian leu |
| `RSD` | Serbian dinar |
| `RUB` | Russian ruble |
| `RWF` | Rwandan franc |
| `SAR` | Saudi riyal |
| `SBD` | Solomon Islands dollar |
| `SCR` | Seychelles rupee |
| `SDG` | Sudanese pound |
| `SEK` | Swedish krona |
| `SGD` | Singapore dollar |
| `SHP` | Saint Helena pound |
| `SLL` | Sierra Leonean first leone |
| `SLE` | Sierra Leonean second leone |
| `SOS` | Somali shilling |
| `SRD` | Surinamese dollar |
| `SSP` | South Sudanese pound |
| `STD` | São Tomé and Príncipe dobra |
| `SVC` | Salvadoran colón |
| `SYP` | Syrian pound |
| `SZL` | Swazi lilangeni |
| `THB` | Thai baht |
| `TJS` | Tajikstani somoni |
| `TMT` | Turkmenistan manat |
| `TND` | Tunisian dinar |
| `TOP` | Tongan pa'anga |
| `TRY` | Turkish lira |
| `TTD` | Trinidad and Tobago dollar |
| `TWD` | New Taiwan dollar |
| `TZS` | Tanzanian shilling |
| `UAH` | Ukrainian hryvnia |
| `UGX` | Ugandan shilling |
| `USD` | United States dollar |
| `USN` | United States dollar (next day) |
| `USS` | United States dollar (same day) |
| `UYI` | Uruguay Peso en Unidedades Indexadas |
| `UYU` | Uruguyan peso |
| `UZS` | Uzbekistan som |
| `VEF` | Venezuelan bolívar soberano |
| `VND` | Vietnamese đồng |
| `VUV` | Vanuatu vatu |
| `WST` | Samoan tala |
| `XAF` | CFA franc BEAC |
| `XAG` | Silver |
| `XAU` | Gold |
| `XBA` | European Composite Unit |
| `XBB` | European Monetary Unit |
| `XBC` | European Unit of Account 9 |
| `XBD` | European Unit of Account 17 |
| `XCD` | East Caribbean dollar |
| `XDR` | Special drawing rights (International Monetary Fund) |
| `XOF` | CFA franc BCEAO |
| `XPD` | Palladium |
| `XPF` | CFP franc |
| `XPT` | Platinum |
| `XTS` | Code reserved for testing |
| `XXX` | No currency |
| `YER` | Yemeni rial |
| `ZAR` | South African rand |
| `ZMK` | Zambian kwacha |
| `ZMW` | Zambian kwacha |
| `BTC` | Bitcoin |
| `XUS` | USD Coin |

