<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Services_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'services_widget';
    }

    public function get_title() {
        return __( 'Services Widget', 'services-widget' );
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function register_controls() {
        /* --------------------------
         * QUERY SECTION
         -------------------------- */
        $this->start_controls_section(
            'query_section',
            [ 'label' => __( 'Query Settings', 'services-widget' ) ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Number of Services', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Order', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'services-widget' ),
                    'ASC'  => __( 'Ascending', 'services-widget' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * LAYOUT / COLUMNS
         -------------------------- */
        $this->start_controls_section(
            'layout_section',
            [ 'label' => __( 'Layout Settings', 'services-widget' ) ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __( 'Columns', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-12 col-sm-6'        => __( '2 Columns', 'services-widget' ),
                    'col-12 col-md-4'        => __( '3 Columns', 'services-widget' ),
                    'col-12 col-md-3'        => __( '4 Columns', 'services-widget' ),
                ],
                'default' => 'col-12 col-lg-4 col-md-6',
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * CONTENT CONTROLS
         -------------------------- */
        $this->start_controls_section(
            'content_options',
            [ 'label' => __( 'Content Options', 'services-widget' ) ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __( 'Excerpt Length (words)', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
                'condition' => [ 'show_excerpt' => 'yes' ],
            ]
        );

        $this->add_control(
            'show_readmore',
            [
                'label' => __( 'Show Read More Button', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'readmore_text',
            [
                'label' => __( 'Read More Text', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Read More', 'services-widget' ),
                'condition' => [ 'show_readmore' => 'yes' ],
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * STYLE: TITLE
         -------------------------- */
        $this->start_controls_section(
            'title_style',
            [ 'label' => __( 'Title', 'services-widget' ), 'tab' => \Elementor\Controls_Manager::TAB_STYLE ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .service-card h4 a' => 'color: {{VALUE}};' ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .service-card h4 a',
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * STYLE: CONTENT
         -------------------------- */
        $this->start_controls_section(
            'content_style',
            [ 'label' => __( 'Content', 'services-widget' ), 'tab' => \Elementor\Controls_Manager::TAB_STYLE ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => __( 'Text Color', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .service-card p' => 'color: {{VALUE}};' ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .service-card p',
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * STYLE: READ MORE BUTTON
         -------------------------- */
        $this->start_controls_section(
            'readmore_style',
            [ 'label' => __( 'Read More Button', 'services-widget' ), 'tab' => \Elementor\Controls_Manager::TAB_STYLE ]
        );

        $this->add_control(
            'readmore_color',
            [
                'label' => __( 'Color', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [ '{{WRAPPER}} .service-card a.readmore-btn' => 'color: {{VALUE}};' ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'readmore_typography',
                'selector' => '{{WRAPPER}} .service-card a.readmore-btn',
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * STYLE: IMAGE
         -------------------------- */
        $this->start_controls_section(
            'image_style',
            [ 'label' => __( 'Thumbnail', 'services-widget' ), 'tab' => \Elementor\Controls_Manager::TAB_STYLE ]
        );

        $this->add_responsive_control(
            'thumb_height',
            [
                'label' => __( 'Height', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'vh' ],
                'selectors' => [ '{{WRAPPER}} .service-card .service-image img' => 'height: {{SIZE}}{{UNIT}}; object-fit: cover;' ],
            ]
        );

        $this->add_control(
            'thumb_radius',
            [
                'label' => __( 'Border Radius', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 50 ] ],
                'selectors' => [ '{{WRAPPER}} .service-card .service-image img' => 'border-radius: {{SIZE}}{{UNIT}};' ],
            ]
        );

        $this->end_controls_section();

        /* --------------------------
         * STYLE: CARD BOX
         -------------------------- */
        $this->start_controls_section(
            'card_style',
            [ 'label' => __( 'Card Box', 'services-widget' ), 'tab' => \Elementor\Controls_Manager::TAB_STYLE ]
        );

        $this->add_control(
            'card_bg',
            [
                'label' => __( 'Background Color', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [ '{{WRAPPER}} .service-card' => 'background-color: {{VALUE}};' ],
            ]
        );

        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __( 'Padding', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .service-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'card_radius',
            [
                'label' => __( 'Border Radius', 'services-widget' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 50 ] ],
                'selectors' => [ '{{WRAPPER}} .service-card' => 'border-radius: {{SIZE}}{{UNIT}};' ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
      
        $args = [
            'post_type'      => 'services',
            'posts_per_page' => $settings['posts_per_page'],
            'order'          => $settings['order'],
        ];

        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) {
            echo '<div class="row">';
            while ( $query->have_posts() ) {
                $query->the_post();
                $col_class = $settings['columns']; ?>
                
                <div class="<?php echo esc_attr($col_class); ?> mb-4">
                    <div class="service-card shadow h-100">
                        <div class="service-image position-relative">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'medium_large', ['class' => 'img-fluid w-100'] ); ?>
                                </a>
                            <?php endif; ?>

                        </div>
                        <div class="service-content mt-3">
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                            <?php if ( 'yes' === $settings['show_excerpt'] ) : ?>
                                <p><?php echo wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '...' ); ?></p>
                            <?php endif; ?>

                            <?php if ( 'yes' === $settings['show_readmore'] ) : ?>
                                <a href="<?php the_permalink(); ?>" class="readmore-btn">
                                    <?php echo esc_html( $settings['readmore_text'] ); ?> →
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <style>
                    .service-card {
                        border: 1px solid #18a8874f !important;
                        transition: all 300ms ease;
                          height: 100%;
                    }
                        .service-card:hover{
                            box-shadow: 0 10px 60px rgba(0, 0, 0, 0.07);
                            border: 1px solid transparent !important;
                            transform: translateY(-8px);
                        }
                    .service-content.mt-3 {
                        position: relative;
                        padding: 15px 15px 15px !important;
                        margin: 0 !important;
                    }
                    .service-image.position-relative img {
                        height: 260px;
                        aspect-ratio: 1 / 1;
                        width: 100%;
                        object-fit: cover;
                    }
                

                </style>
            <?php }
            echo '</div>';
            wp_reset_postdata();
        }
    }
}
