<?php $settings['settings'] = $settings; ?>
<?php
	wp_enqueue_style( 'swiper' );
	wp_enqueue_script( 'swiper' );
	//Swiper Slider Data
	$swiper_slide_data_info = mascot_core_carer_swiper_data_params( $settings );
?>
<?php if ( $features_items_array ) : ?>
	<div id="<?php echo esc_attr( $holder_id ) ?>" class="tm-sc-features tm-features-carousel tm-swiper-container" <?php echo html_entity_decode( esc_attr( implode(' ', $swiper_slide_data_info) ) ) ?>>
		<div class="swiper-container-inner">
			<div class="swiper-wrapper">
				<!-- the loop -->
				<?php foreach (  $features_items_array as $features_item ) { ?>
					<?php $settings['features_item'] = $features_item; ?>
					<?php
						$animation = "";
						$animation_delay = "";
						if(isset($features_item['wow_appear_animation']) && !empty($features_item['wow_appear_animation'])) {
							$animation = $features_item['wow_appear_animation'];
						}
						if(isset($features_item['wow_animation_delay']) && !empty($features_item['wow_animation_delay'])) {
							$animation_delay = $features_item['wow_animation_delay'] . 'ms';
						}
					?>
					<div class="swiper-slide elementor-repeater-item-<?php echo $features_item['_id']; ?> <?php echo esc_attr($animation);?>" data-wow-delay="<?php echo esc_attr($animation_delay);?>">
						<?php mascot_core_carer_get_shortcode_template_part( 'features-item', $_skin, 'features-block/tpl', $settings, false ); ?>
					</div>
				<?php } ?>
				<!-- end of the loop -->
			</div>
		</div>

		<div class="swiper-pagination <?php if( $bullets !== 'yes' ) echo esc_attr( "d-none" ); ?>"></div>

		<div class="tm-swiper-arrow tm-swiper-button-wrap <?php if( $arrow !== 'yes' ) echo esc_attr( "d-none" ); ?>">
			<div class="tm-swiper-arrow tm-swiper-button-prev"><i class="lnr-icon-arrow-left"></i></div>
			<div class="tm-swiper-arrow tm-swiper-button-next"><i class="lnr-icon-arrow-right"></i></div>
		</div>
	</div>

<?php else : ?>
	<?php mascot_core_carer_no_posts_match_criteria_text(); ?>
<?php endif; ?>